#
#
#
#                    1. run CBAero
#   % cbaero
#   -noblank     #  no blanking for newtonian
#   -noentropy   #  no entropy swallowing model
#   -omp 4       #  use 4 cores
#   -turbulent   # laminar, turbulent, inviscid, free-molecular
#   -testrunb  %f %f %f %f %f  # mrtab = mach [] rho [kg/m^3] temp [K] alpha [deg] beta [deg]
#                                      =  10.     0.40681     222.397    4.0       0.000000
#   -alternative is "testrun %f %f %f %f" <Mach> <rho> <temp>  <alpha>
#   <config_name>  #  config_name.msh -- leave off the extension
cbaero -noblank -noentropy -omp 4 -anchor -turbulent -scale 1.000000e+00 -testrunb 10.0  0.40681 222.397  4.0 0.000000 doe_stream

#                   2. Make *adb file from the Cart3D *triq file in the $CFD directory
#  % triq2adb
#     -eq  # Cart3D used equilibrium air equi_flowCart solution
#     -cut     #  ??????? -- undocumented
#     -mrtab %f %f %f %f %f = mach [] rho [kg/m^3] temp [K] alpha [deg] beta [deg]
#                           =  10.     0.40681     222.397    4.0       0.000000
#     <triqfilename>  #  leave off the extension
triq2adb -cut -mrtab  10.0  0.40681 222.397  4.0 0.000000 ../CFD/Components.i
ln -sf ../../CFD/Components.i.cart3d.adb cfd.adb

#                  3. take slices for line-plot comparison
#   adb2slice #  ...see CBaero Manual
#       <*adb file>   # no extension
#       %d %d %d      # index of Mach-Q-Alpha database for the case you want to slice
#       -x/y/z
adb2slice doe_stream 1 1 1 -y 0.
mv doe_stream.slc doe_stream.centerline.slc

adb2slice cfd 1 1 1 -y 0.0001
mv cfd.slc cfd.centerline.slc

#                 4. now plot using gnuplot
gnuplot compare.viscous.gnuplot
