set term pdfcairo noenhanced
set pointsize 0.50
set out 'compare.cbaero.anchor_noAnchor.viscous.pdf'
set grid
set mxtics
set mytics


set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  Pressure vs. X  \n CFD Case: 1"
set xlabel "X, m"
set ylabel "Pressure, MPa"
plot "doe_stream.centerline.slc" using 1:($4/1000000) index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 1:($4/1000000) index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 1:($4/1000000) index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set yrange [0:550]
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  Convective Qdot vs. X \n CFD Case: 1 "
set xlabel "X, m"
set ylabel "Convective Qdot, W/cm^2"
plot "doe_stream.centerline.slc" using 1:($7/10000) index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 1:($7/10000) index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 1:($7/10000) index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set yrange [0:3500]
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  Temperature Qdot vs. X \n CFD Case: 1"
set xlabel "X, m"
set ylabel "Temperature, K"
plot "doe_stream.centerline.slc" using 1:6 index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 1:6 index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 1:6 index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set yrange [0:8200]
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  Shear Magntiude vs. X \n CFD Case: 1"
set xlabel "X, m"
set ylabel "Shear Magnitude, Pa"
plot "doe_stream.centerline.slc" using 1:11 index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 1:11 index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 1:11 index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set yrange [0:11000]
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  ReTheta vs. X \n CFD Case: 1"
set xlabel "X, m"
set ylabel "ReTheta"
plot "doe_stream.centerline.slc" using 1:14 index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 1:14 index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 1:14 index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set yrange [0:3500]
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  ReTheta/Me vs. X \n CFD Case: 1"
set xlabel "X, m"
set ylabel "ReTheta/Me"
plot "doe_stream.centerline.slc" using 1:15 index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 1:15 index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 1:15 index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set autoscale
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  Pressure vs. Z \n CFD Case: 1 \n CFD File: ../../CFD/Components.i "
set xlabel "Z, m"
set ylabel "Pressure, MPa"
plot "doe_stream.centerline.slc" using 3:($4/1000000) index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 3:($4/1000000) index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 3:($4/1000000) index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set yrange [0:550]
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  Convective Qdot vs. Z \n CFD Case: 1  "
set xlabel "z, m"
set ylabel "Convective Qdot, W/cm^2"
plot "doe_stream.centerline.slc" using 3:($7/10000) index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 3:($7/10000) index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 3:($7/10000) index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"


set yrange [0:3500]
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  Temperature vs. Z \n CFD Case: 1  "
set xlabel "Z, m"
set ylabel "Temperature, K"
plot "doe_stream.centerline.slc" using 3:6 index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 3:6 index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 3:6 index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set yrange [0:8200]
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  Shear Magntiude vs. Z \n CFD Case: 1 "
set xlabel "Z, m"
set ylabel "Shear Magnitude, Pa"
plot "doe_stream.centerline.slc" using 3:11 index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 3:11 index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 3:11 index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set yrange [0:11000]
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  ReTheta vs. Z \n CFD Case: 1 "
set xlabel "Z, m"
set ylabel "ReTheta"
plot "doe_stream.centerline.slc" using 3:14 index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 3:14 index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 3:14 index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set yrange [0:3500]
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  ReTheta/Me vs. Z "
set xlabel "Z, m"
set ylabel "ReTheta/Me"
plot "doe_stream.centerline.slc" using 3:15 index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 3:15 index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 3:15 index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set autoscale
set title "Centerline Slice for Mach 10, AoA = 4 at Alt=10132m \n  Viscosity vs. Z "
set xlabel "Z, m"
set ylabel "Viscosity,Pa-sec"
plot "doe_stream.centerline.slc" using 3:17 index 0  title "Anchored, turbulent" with points pt 7 ps 0.5 lc rgb "red", \
     "noanchor.centerline.slc" using 3:17 index 0  title "CBAERO only" with points lw 1   lc rgb "orange", \
     "cfd.centerline.slc" using 3:17 index 0  title "Cart3D only" with points lw 1 pt 4 ps 0.5  lc rgb "blue"
#pause -1 "Hit return to continue"

set autoscale
