set term pdfcairo noenhanced 
set out 'doe_stream.pdf' 
set grid 
set mxtics 
set mytics 
# CL vs Alpha 
set xlabel 'Angle of Attack (degrees)' 
set ylabel 'CL' 
set title 'Beta: 0.000000 ... Q: 18.178941 ... MACH: 10.000000 --- Lift Coefficent vs. Angle of Attack' 
plot 'doe_stream.plt' using 2:6 index 0  title 'CL' with lines lw 2 
#pause -1 'Hit return to continue' 


# CL vs CD 
set xlabel 'CD' 
set ylabel 'CL' 
set title 'Beta: 0.000000 ... Q: 18.178941 ... MACH: 10.000000 --- Drag Polar (CL vs. CD)' 
plot 'doe_stream.plt' using 7:6 index 0  title 'CL' with lines lw 2 
#pause -1 'Hit return to continue' 


# CM vs Alpha 
set xlabel 'Angle of Attack (degrees)' 
set ylabel 'CM' 
set title 'Beta: 0.000000 ... Q: 18.178941 ... MACH: 10.000000 --- Moment Coefficent vs. Angle of Attack' 
plot 'doe_stream.plt' using 2:8 index 0  title 'CM' with lines lw 2 
#pause -1 'Hit return to continue' 


# L/D vs Alpha 
set xlabel 'Angle of Attack (degrees)' 
set ylabel 'L/D' 
set title 'Beta: 0.000000 ... Q: 0.000000 ... MACH: 18.178941 --- Lift to Drag Ratio vs. Angle of Attack' 
plot 'doe_stream.plt' using 2:9 index 0  title 'L/D' with lines lw 2 
#pause -1 'Hit return to continue' 




#StagTemp vs Alpha 
set xlabel 'Angle of Attack (degrees)' 
set ylabel 'Stagnation Temperature, degree K' 
set title 'Beta: 0.000000 ... Q: 18.178941 ... MACH: 10.000000 --- Stagnation Temperature vs. Angle of Attack' 
plot 'doe_stream.plt' using 2:14 index 0  title 'Stagnation Temperature' with lines lw 2 
#pause -1 'Hit return to continue' 




#StagQdot Convection vs Alpha 
set xlabel 'Angle of Attack (degrees)' 
set ylabel 'Convective Heating, Watts/cm^2' 
set title 'Beta: 0.000000 ... Q: 18.178941 ... MACH: 10.000000 --- Convective Heating vs. Angle of Attack' 
plot 'doe_stream.plt' using 2:($15/10000.) index 0  title 'Convective Qdot' with lines lw 2 
#pause -1 'Hit return to continue' 




#StagQdot Radiative vs Alpha 
set xlabel 'Angle of Attack (degrees)' 
set ylabel 'Radiative Heating, Watts/cm^2' 
set title 'Beta: 0.000000 ... Q: 18.178941 ... MACH: 10.000000 --- Radiative Heating vs. Angle of Attack' 
plot 'doe_stream.plt' using 2:($16/10000.) index 0  title 'Radiative Qdot' with lines lw 2 
#pause -1 'Hit return to continue' 




#Stagnation Radius vs Alpha 
set xlabel 'Angle of Attack (degrees)' 
set ylabel 'Stagnation Radius, meters' 
set title 'Beta: 0.000000 ... Q: 18.178941 ... MACH: 10.000000 --- Stagnation Radius vs. Angle of Attack' 
plot 'doe_stream.plt' using 2:17 index 0  title 'Stagnation Radius' with lines lw 2 
#pause -1 'Hit return to continue' 




